<?php
/* --------------------------------------------------------------
 Configuration.php 2020-03-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Models\Read;

use Gambio\Core\Configuration\Models\Read\Interfaces\Configuration as ConfigurationInterface;

/**
 * Class Configuration
 * @package Gambio\Core\Configuration\Models\Read
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @var string
     */
    private $key;
    
    /**
     * @var string|null
     */
    private $value;
    
    
    /**
     * Configuration constructor.
     *
     * @param string      $key
     * @param string|null $value
     */
    private function __construct(string $key, ?string $value)
    {
        $this->key   = $key;
        $this->value = $value;
    }
    
    
    /**
     * Factory method for Configuration.
     *
     * @param string      $key
     * @param string|null $value
     *
     * @return static
     */
    public static function create(string $key, ?string $value): self
    {
        return new static($key, $value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function key(): string
    {
        return $this->key;
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): ?string
    {
        return $this->value;
    }
}